(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     22421,        563]
NotebookOptionsPosition[     20092,        509]
NotebookOutlinePosition[     20694,        529]
CellTagsIndexPosition[     20651,        526]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["B|  Typical soil parameters", "Section",
 CellFrame->{{0.5, 3}, {3, 0.5}},
 CellChangeTimes->{{3.964146927820764*^9, 3.9641469635526257`*^9}, 
   3.970500822940824*^9, 3.971780469721634*^9},
 FontColor->GrayLevel[
  0],ExpressionUUID->"a916188c-e729-4d95-8836-82f6ed9c6968"],

Cell["\<\
Soil parameters should come from insitu or laboratory tests. However, for \
preliminary results, or a sanity check, the following table may be useful.\
\>", "Text",
 CellChangeTimes->{{3.9728187518099213`*^9, 3.972818886955858*^9}, {
  3.972818941354233*^9, 3.9728189451817083`*^9}},
 CellID->1811861914,ExpressionUUID->"f0bfeb66-a8ca-4ee7-902b-ac458a245b3b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"soilTypes", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*StyleBox[\"Soil\",FontWeight->\"Bold\"]\)\!\(\*\
StyleBox[\" \
\",FontWeight->\"Bold\"]\)\!\(\*StyleBox[\"Type\",FontWeight->\"Bold\"]\)\>\"",
        ",", "\"\<\!\(\*StyleBox[\"Eh\",FontWeight->\"Bold\"]\) [MPa]\>\"", 
       ",", "\"\<\!\(\*StyleBox[\"Ev\",FontWeight->\"Bold\"]\) MPa\>\"", 
       ",", "\"\<\!\(\*StyleBox[\"Ev\",FontWeight->\"Bold\"]\)\!\(\*StyleBox[\
\"/\",FontWeight->\"Bold\"]\)\!\(\*StyleBox[\"Eh\",FontWeight->\"Bold\"]\)\>\"\
", ",", "\"\<\!\(\*StyleBox[\"\[Nu]hh\",FontWeight->\"Bold\"]\)\>\"", 
       ",", "\"\<\!\(\*StyleBox[\"\[Nu]hv\",FontWeight->\"Bold\"]\)\>\"", 
       ",", "\"\<\!\(\*StyleBox[\"Ghv\",FontWeight->\"Bold\"]\) MPa\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Soft Clay\>\"", ",", "\"\<5-20\>\"", ",", "\"\<2-10\>\"", 
       ",", "\"\<0.3-0.7\>\"", ",", "\"\<0.25-0.35\>\"", 
       ",", "\"\<0.15-0.25\>\"", ",", "\"\<2-8\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Stiff Clay\>\"", ",", "\"\<20-100\>\"", 
       ",", "\"\<10-50\>\"", ",", "\"\<0.4-0.8\>\"", ",", "\"\<0.20-0.30\>\"",
        ",", "\"\<0.10-0.20\>\"", ",", "\"\<8-30\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Dense Sand\>\"", ",", "\"\<30-150\>\"", 
       ",", "\"\<25-120\>\"", ",", "\"\<0.7-0.9\>\"", ",", "\"\<0.25-0.35\>\"",
        ",", "\"\<0.15-0.30\>\"", ",", "\"\<15-60\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Loose Sand\>\"", ",", "\"\<10-50\>\"", ",", "\"\<8-40\>\"",
        ",", "\"\<0.7-0.9\>\"", ",", "\"\<0.30-0.40\>\"", 
       ",", "\"\<0.20-0.35\>\"", ",", "\"\<5-20\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Layered Shale\>\"", ",", "\"\<1000-5000\>\"", 
       ",", "\"\<500-2500\>\"", ",", "\"\<0.4-0.6\>\"", 
       ",", "\"\<0.15-0.25\>\"", ",", "\"\<0.10-0.20\>\"", 
       ",", "\"\<400-2000\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Compacted Fill\>\"", ",", "\"\<25-80\>\"", 
       ",", "\"\<15-50\>\"", ",", "\"\<0.5-0.8\>\"", ",", "\"\<0.20-0.30\>\"",
        ",", "\"\<0.15-0.25\>\"", ",", "\"\<10-35\>\""}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.972732972609357*^9, 3.972732979637535*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"ca3707b4-d021-4fc3-acdf-ff6cdaf97a37"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"TableForm", "[", 
    RowBox[{"soilTypes", ",", 
     RowBox[{"TableHeadings", "->", "None"}], ",", 
     RowBox[{"TableAlignments", "->", 
      RowBox[{"{", 
       RowBox[{
       "Left", ",", "Center", ",", "Center", ",", "Center", ",", "Center", ",",
         "Center", ",", "Center"}], "}"}]}]}], "]"}], "]"}], ";"}]], "Input",
 CellOpen->False,
 CellLabel->
  "In[125]:=",ExpressionUUID->"5716f6bd-c46e-451c-8b96-d1cfa9b50f82"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\\!\\(\\*StyleBox[\\\"Soil\\\",FontWeight->\\\"Bold\\\"]\\)\\!\\(\\*\
StyleBox[\\\" \
\\\",FontWeight->\\\"Bold\\\"]\\)\\!\\(\\*StyleBox[\\\"Type\\\",FontWeight->\\\
\"Bold\\\"]\\)\"\>", "\<\"\\!\\(\\*StyleBox[\\\"Eh\\\",FontWeight->\\\"Bold\\\
\"]\\) [MPa]\"\>", \
"\<\"\\!\\(\\*StyleBox[\\\"Ev\\\",FontWeight->\\\"Bold\\\"]\\) MPa\"\>", \
"\<\"\\!\\(\\*StyleBox[\\\"Ev\\\",FontWeight->\\\"Bold\\\"]\\)\\!\\(\\*\
StyleBox[\\\"/\\\",FontWeight->\\\"Bold\\\"]\\)\\!\\(\\*StyleBox[\\\"Eh\\\",\
FontWeight->\\\"Bold\\\"]\\)\"\>", \
"\<\"\\!\\(\\*StyleBox[\\\"\[Nu]hh\\\",FontWeight->\\\"Bold\\\"]\\)\"\>", "\<\
\"\\!\\(\\*StyleBox[\\\"\[Nu]hv\\\",FontWeight->\\\"Bold\\\"]\\)\"\>", \
"\<\"\\!\\(\\*StyleBox[\\\"Ghv\\\",FontWeight->\\\"Bold\\\"]\\) MPa\"\>"},
    {"\<\"Soft Clay\"\>", "\<\"5-20\"\>", "\<\"2-10\"\>", "\<\"0.3-0.7\"\>", \
"\<\"0.25-0.35\"\>", "\<\"0.15-0.25\"\>", "\<\"2-8\"\>"},
    {"\<\"Stiff Clay\"\>", "\<\"20-100\"\>", "\<\"10-50\"\>", \
"\<\"0.4-0.8\"\>", "\<\"0.20-0.30\"\>", "\<\"0.10-0.20\"\>", "\<\"8-30\"\>"},
    {"\<\"Dense Sand\"\>", "\<\"30-150\"\>", "\<\"25-120\"\>", "\<\"0.7-0.9\"\
\>", "\<\"0.25-0.35\"\>", "\<\"0.15-0.30\"\>", "\<\"15-60\"\>"},
    {"\<\"Loose Sand\"\>", "\<\"10-50\"\>", "\<\"8-40\"\>", \
"\<\"0.7-0.9\"\>", "\<\"0.30-0.40\"\>", "\<\"0.20-0.35\"\>", "\<\"5-20\"\>"},
    {"\<\"Layered Shale\"\>", "\<\"1000-5000\"\>", "\<\"500-2500\"\>", \
"\<\"0.4-0.6\"\>", "\<\"0.15-0.25\"\>", "\<\"0.10-0.20\"\>", \
"\<\"400-2000\"\>"},
    {"\<\"Compacted Fill\"\>", "\<\"25-80\"\>", "\<\"15-50\"\>", "\<\"0.5-0.8\
\"\>", "\<\"0.20-0.30\"\>", "\<\"0.15-0.25\"\>", "\<\"10-35\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, TableHeadings -> None, 
    TableAlignments -> {
     Left, Center, Center, Center, Center, Center, Center}]]]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.96356822359305*^9, 3.965092665307198*^9, 
  3.972732986857233*^9, 3.972733278585251*^9},
 CellLabel->
  "During evaluation of \
In[125]:=",ExpressionUUID->"e06b680e-0088-404b-a330-fd45741c2392"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
For transversely isotropic soils the required parameters are:-\
\>", "Subsubsection",
 CellChangeTimes->{{3.972748283964973*^9, 3.972748320297039*^9}},
 CellID->2086857614,ExpressionUUID->"1cd3de89-b46d-4da6-8b85-eb978d947608"],

Cell[BoxData[
 RowBox[{"pars", "=", 
  RowBox[{"<|", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\"\<YoungModulusH\>\"", "->", "Eh"}], ",", 
    RowBox[{"(*", 
     RowBox[{"In", "-", 
      RowBox[{"plane", " ", "modulus"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\"\<YoungModulusV\>\"", "->", "Ev"}], ",", 
    RowBox[{"(*", 
     RowBox[{"Out", "-", "of", "-", 
      RowBox[{"plane", " ", "modulus"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\"\<PoissonRatioHH\>\"", "->", "\[Nu]hh"}], ",", 
    RowBox[{"(*", 
     RowBox[{"In", "-", 
      RowBox[{"plane", " ", "to", " ", "in"}], "-", "plane"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"\"\<PoissonRatioHV\>\"", "->", "\[Nu]hv"}], ",", 
    RowBox[{"(*", 
     RowBox[{"Horizontal", " ", "to", " ", "vertical"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"\"\<PoissonRatioVH\>\"", "->", "\[Nu]vh"}], ",", 
    RowBox[{"(*", 
     RowBox[{"Vertical", " ", "to", " ", "horizontal"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"\"\<ShearModulusHV\>\"", "->", "Ghv"}]}], "     ", 
   RowBox[{"(*", 
    RowBox[{"Shear", " ", "between", " ", "planes"}], "*)"}], 
   "|>"}]}]], "Input",
 CellChangeTimes->{{3.972748205317255*^9, 3.97274820531956*^9}, {
  3.972748241546344*^9, 3.972748267542351*^9}},
 CellID->1342670546,ExpressionUUID->"0aab1df1-e9a3-42ec-ac70-02615a191a47"],

Cell["\<\
Here is an assumed set of parameters for a transversely isotropic soil.\
\>", "Text",
 CellChangeTimes->{{3.9728184817904377`*^9, 3.972818508891426*^9}},
 CellID->105986853,ExpressionUUID->"b5fbfc73-30ce-46c5-bc09-645507f7b925"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Eh", "=", "50"}], ";", 
  RowBox[{"Ev", "=", "MPa"}], ";", 
  RowBox[{"Ghv", "=", "15"}], ";", 
  RowBox[{"\[Nu]hh", "=", "0.3"}], ";", 
  RowBox[{"\[Nu]hv", "=", "\[Nu]hh"}], ";"}]], "Input",
 CellOpen->False,
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{
  3.972746328300989*^9, {3.972746442322352*^9, 3.9727465287128267`*^9}, {
   3.972746692666944*^9, 3.972746699357801*^9}, {3.972815995305368*^9, 
   3.972816037172069*^9}, 3.9728185394994307`*^9},
 CellLabel->"In[1]:=",
 CellID->750821714,ExpressionUUID->"0306ac2b-26fb-4219-9024-c906da3f9766"],

Cell[BoxData[
 RowBox[{
  RowBox[{"params", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*StyleBox[\"Parameter\",FontWeight->\"Bold\"]\)\>\"", 
       ",", "\"\<\!\(\*StyleBox[\"Symbol\",FontWeight->\"Bold\"]\)\>\"", 
       ",", "\"\<\!\(\*StyleBox[\"Value\",FontWeight->\"Bold\"]\)\>\"", 
       ",", "\"\<\!\(\*StyleBox[\"Units\",FontWeight->\"Bold\"]\)\>\"", 
       ",", "\"\<\!\(\*StyleBox[\"Description\",FontWeight->\"Bold\"]\)\>\""}]\
, "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Young's Modulus (horizontal)\>\"", ",", "\"\<Eh\>\"", ",", 
       "Eh", ",", "\"\<MPa\>\"", ",", "\"\<Stiffness in x,y directions\>\""}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Young's Modulus (vertical)\>\"", ",", "\"\<Ev\>\"", ",", 
       "Ev", ",", "\"\<MPa\>\"", ",", "\"\<Stiffness in z direction\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Poisson's Ratio (h-h)\>\"", ",", "\"\<\[Nu]hh\>\"", ",", 
       "\[Nu]hh", ",", "\"\<-\>\"", 
       ",", "\"\<Lateral strain ratio in horizontal plane\>\""}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"\"\<Poisson's Ratio (h-v)\>\"", ",", "\"\<\[Nu]hv\>\"", ",", 
       "\[Nu]hv", ",", "\"\<-\>\"", 
       ",", "\"\<Vertical strain from horizontal stress\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Poisson's Ratio (v-h)\>\"", ",", "\"\<\[Nu]vh\>\"", ",", 
       "\[Nu]vh", ",", "\"\<-\>\"", 
       ",", "\"\<Horizontal strain from vertical stress\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Shear Modulus (h-v)\>\"", ",", "\"\<Ghv\>\"", ",", "Ghv", 
       ",", "\"\<MPa\>\"", 
       ",", "\"\<Shear stiffness in vertical planes\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Shear Modulus (h-h)\>\"", ",", "\"\<Ghh\>\"", ",", 
       FractionBox["Eh", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Nu]hv"}], ")"}]}]], ",", "\"\<MPa\>\"", 
       ",", "\"\<Shear stiffness in horizontal plane\>\""}], "}"}]}], "}"}]}],
   ";"}]], "Input",
 CellOpen->False,
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.9635682763318357`*^9, 3.9635682775869007`*^9}, {
   3.972746284094182*^9, 3.9727463346157722`*^9}, {3.9727465981636753`*^9, 
   3.972746619426993*^9}, {3.9728160644120693`*^9, 3.972816078448296*^9}, 
   3.972816140247363*^9, 3.97281618160156*^9, 3.972818539499693*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"efcd395e-f41a-45e1-b7ef-015925b37cf1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"TableForm", "[", 
    RowBox[{"params", ",", 
     RowBox[{"TableHeadings", "->", "None"}], ",", 
     RowBox[{"TableAlignments", "->", 
      RowBox[{"{", 
       RowBox[{
       "Left", ",", "Center", ",", "Right", ",", "Center", ",", "Left"}], 
       "}"}]}]}], "]"}], "]"}], ";"}]], "Input",
 CellOpen->False,
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{3.972818539499772*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"5f5b6158-8185-4aa5-8cc6-778373216699"]
}, Closed]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\\!\\(\\*StyleBox[\\\"Parameter\\\",FontWeight->\\\"Bold\\\"]\\)\"\>\
", "\<\"\\!\\(\\*StyleBox[\\\"Symbol\\\",FontWeight->\\\"Bold\\\"]\\)\"\>", "\
\<\"\\!\\(\\*StyleBox[\\\"Value\\\",FontWeight->\\\"Bold\\\"]\\)\"\>", \
"\<\"\\!\\(\\*StyleBox[\\\"Units\\\",FontWeight->\\\"Bold\\\"]\\)\"\>", "\<\"\
\\!\\(\\*StyleBox[\\\"Description\\\",FontWeight->\\\"Bold\\\"]\\)\"\>"},
    {"\<\"Young's Modulus (horizontal)\"\>", "\<\"Eh\"\>", 
     "50", "\<\"MPa\"\>", "\<\"Stiffness in x,y directions\"\>"},
    {"\<\"Young's Modulus (vertical)\"\>", "\<\"Ev\"\>", 
     "MPa", "\<\"MPa\"\>", "\<\"Stiffness in z direction\"\>"},
    {"\<\"Poisson's Ratio (h-h)\"\>", "\<\"\[Nu]hh\"\>", 
     "0.3`", "\<\"-\"\>", "\<\"Lateral strain ratio in horizontal \
plane\"\>"},
    {"\<\"Poisson's Ratio (h-v)\"\>", "\<\"\[Nu]hv\"\>", 
     "0.3`", "\<\"-\"\>", "\<\"Vertical strain from horizontal stress\"\>"},
    {"\<\"Poisson's Ratio (v-h)\"\>", "\<\"\[Nu]vh\"\>", 
     "\[Nu]vh", "\<\"-\"\>", "\<\"Horizontal strain from vertical stress\"\>"},
    {"\<\"Shear Modulus (h-v)\"\>", "\<\"Ghv\"\>", 
     "15", "\<\"MPa\"\>", "\<\"Shear stiffness in vertical planes\"\>"},
    {"\<\"Shear Modulus (h-h)\"\>", "\<\"Ghh\"\>", 
     "19.23076923076923`", "\<\"MPa\"\>", "\<\"Shear stiffness in horizontal \
plane\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, TableHeadings -> None, 
    TableAlignments -> {Left, Center, Right, Center, Left}]]]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.963568291960669*^9, {3.972746106529483*^9, 3.972746106903607*^9}, {
   3.9727462215412807`*^9, 3.972746221775373*^9}, 3.972746351011845*^9, 
   3.97281611123359*^9, 3.9728161466036797`*^9, 3.9728161925883102`*^9},
 CellLabel->"During evaluation of In[7]:=",
 CellID->159376748,ExpressionUUID->"891f35d2-aef9-488d-b91d-df4d7bf21bdb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"1.", " ", 
   StyleBox[
    RowBox[{"Poisson", "'"}],
    FontWeight->Bold], 
   StyleBox["s",
    FontWeight->Bold], 
   StyleBox[" ",
    FontWeight->Bold], 
   StyleBox["Ratio",
    FontWeight->Bold], 
   StyleBox[" ",
    FontWeight->Bold], 
   StyleBox[
    RowBox[{"(", 
     RowBox[{"h", "-", "h"}], ")"}],
    FontWeight->Bold]}], ":", "  ", "\n", Cell[TextData[{
   "   ",
   StyleBox["\[Bullet]",
    FontColor->LightDarkSwitched[
      GrayLevel[0.5], 
      GrayLevel[0.7533742]]],
   " Denoted as ",
   Cell[BoxData[
    FormBox[
     TemplateBox[<|"boxes" -> FormBox[
         SubscriptBox["\[Nu]", 
          RowBox[{
            StyleBox["h", "TI"], 
            StyleBox["h", "TI"]}]], TraditionalForm], "errors" -> {}, "input" -> 
       "\\nu_{hh}", "state" -> "Boxes"|>,
      "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
    "55cfcbe4-cf9c-448a-98c3-0509bfde06ae"],
   ", this ratio represents the lateral (horizontal) strain in the material \
when a stress is applied in another horizontal direction. horizontally. It \
indicates how much the material will expand or contract in a direction \
perpendicular to the applied stress."
  }], "InlineSubitem",ExpressionUUID->
   "7108ea2d-35d7-43d2-89d1-148aa3100e93"]}], "\n", 
 RowBox[{
  RowBox[{"2.", " ", 
   StyleBox[
    RowBox[{"Poisson", "'"}],
    FontWeight->Bold], 
   StyleBox["s",
    FontWeight->Bold], 
   StyleBox[" ",
    FontWeight->Bold], 
   StyleBox["Ratio",
    FontWeight->Bold], 
   StyleBox[" ",
    FontWeight->Bold], 
   StyleBox[
    RowBox[{"(", 
     RowBox[{"h", "-", "v"}], ")"}],
    FontWeight->Bold]}], ":", " ", "\n", Cell[TextData[{
   "   ",
   StyleBox["\[Bullet]",
    FontColor->LightDarkSwitched[
      GrayLevel[0.5], 
      GrayLevel[0.7533742]]],
   " Denoted as ",
   Cell[BoxData[
    FormBox[
     TemplateBox[<|"boxes" -> FormBox[
         SubscriptBox["\[Nu]", 
          RowBox[{
            StyleBox["h", "TI"], 
            StyleBox["v", "TI"]}]], TraditionalForm], "errors" -> {}, "input" -> 
       "\\nu_{hv}", "state" -> "Boxes"|>,
      "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
    "11dcf24a-b72a-405f-a0ff-dbfcef967470"],
   ", this ratio describes the vertical strain that occurs due to a \
horizontal stress. "
  }], "InlineSubitem",ExpressionUUID->
   "32ffb40e-386b-4304-a935-2cfe4e04f058"]}], "\n", 
 RowBox[{
  RowBox[{"3.", " ", 
   StyleBox[
    RowBox[{"Poisson", "'"}],
    FontWeight->Bold], 
   StyleBox["s",
    FontWeight->Bold], 
   StyleBox[" ",
    FontWeight->Bold], 
   StyleBox["Ratio",
    FontWeight->Bold], 
   StyleBox[" ",
    FontWeight->Bold], 
   StyleBox[
    RowBox[{"(", 
     RowBox[{"v", "-", "h"}], ")"}],
    FontWeight->Bold]}], ":", " ", "\n", Cell[TextData[{
   "   ",
   StyleBox["\[Bullet]",
    FontColor->LightDarkSwitched[
      GrayLevel[0.5], 
      GrayLevel[0.7533742]]],
   " Denoted as ",
   Cell[BoxData[
    FormBox[
     TemplateBox[<|"boxes" -> FormBox[
         SubscriptBox["\[Nu]", 
          RowBox[{
            StyleBox["v", "TI"], 
            StyleBox["h", "TI"]}]], TraditionalForm], "errors" -> {}, "input" -> 
       "\\nu_{vh}", "state" -> "Boxes"|>,
      "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
    "d3aec529-6fa8-4ad5-8db7-6f2ad4db243f"],
   ", this ratio indicates the horizontal strain that results from a vertical \
stress. "
  }], "InlineSubitem",ExpressionUUID->
   "7a8eeb4b-e17c-4a59-9ea0-786f0636eb0a"]}]}], "TechNote",
 CellChangeTimes->{{3.972747083954833*^9, 3.9727470907218933`*^9}, 
   3.972747148224821*^9, {3.972747786694792*^9, 3.972747822257811*^9}, {
   3.972748396096908*^9, 3.972748418082467*^9}, {3.97274844973849*^9, 
   3.972748459311273*^9}},ExpressionUUID->"cfcd32e8-7db5-4cf0-a675-\
b9f059462be9"],

Cell[TextData[{
 "Now",
 StyleBox[" ",
  FontSize->24],
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     SubscriptBox["\[Nu]", "hv"], 
     SubscriptBox["E", "h"]], "=", 
    RowBox[{
     RowBox[{
      FractionBox[
       SubscriptBox["\[Nu]", "vh"], 
       SubscriptBox["E", "v"]], " ", 
      StyleBox["and",
       FontSize->18], "  ", 
      SubscriptBox["G", "hh"]}], "=", 
     FractionBox[
      SubscriptBox["E", "h"], 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SubscriptBox["\[Nu]", "hh"]}], ")"}]}]], " "}]}], TraditionalForm]],
  FormatType->TraditionalForm,
  FontSize->24,ExpressionUUID->"d8486ac0-4aa2-4ec6-a537-bbb8b8177f13"],
 " but ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Nu]", 
     RowBox[{"hh", " "}]], "is", " ", "independent"}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "ee15853e-52b9-41df-a147-3a5b1e06c488"],
 " of the other properties. It should be measured in a test. If isotropy is \
assumed in the horizontal plane ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Nu]", "hh"], "\[TildeEqual]", 
    SubscriptBox["\[Nu]", "hv"]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "63489619-7acb-4e27-8715-78e49241e54c"]
}], "Text",
 CellFrame->{{0, 0}, {3, 0}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.972817448660817*^9, 3.972817554500787*^9}, {
  3.972817632874165*^9, 3.972817701832717*^9}, {3.972817734976667*^9, 
  3.9728177881438437`*^9}, {3.9728178412601557`*^9, 3.9728178473126497`*^9}, {
  3.972817936727316*^9, 3.972817943412264*^9}, {3.9728180569723873`*^9, 
  3.972818072090843*^9}, {3.972818134772334*^9, 3.9728182095875797`*^9}, {
  3.972818333613356*^9, 3.972818338217647*^9}, {3.9728183721802263`*^9, 
  3.972818411256124*^9}},
 CellID->1588483917,ExpressionUUID->"7f68012b-cc7b-45ff-892e-2a03be8c006f"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 911},
WindowMargins->{{79, Automatic}, {Automatic, 131}},
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "MyBookStyles.nb"]]}, Visible -> False, 
  FrontEndVersion -> "14.3 for Mac OS X ARM (64-bit) (July 8, 2025)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"bfc48641-7326-4d9f-8c36-08a617c046e7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 280, 5, 49, "Section",ExpressionUUID->"a916188c-e729-4d95-8836-82f6ed9c6968"],
Cell[859, 29, 369, 6, 25, "Text",ExpressionUUID->"f0bfeb66-a8ca-4ee7-902b-ac458a245b3b",
 CellID->1811861914],
Cell[1231, 37, 2401, 46, 23, "Input",ExpressionUUID->"ca3707b4-d021-4fc3-acdf-ff6cdaf97a37",
 CellOpen->False],
Cell[CellGroupData[{
Cell[3657, 87, 495, 13, 23, "Input",ExpressionUUID->"5716f6bd-c46e-451c-8b96-d1cfa9b50f82",
 CellOpen->False],
Cell[4155, 102, 2409, 47, 140, "Print",ExpressionUUID->"e06b680e-0088-404b-a330-fd45741c2392"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6601, 154, 237, 4, 25, "Subsubsection",ExpressionUUID->"1cd3de89-b46d-4da6-8b85-eb978d947608",
 CellID->2086857614],
Cell[6841, 160, 1370, 31, 122, "Input",ExpressionUUID->"0aab1df1-e9a3-42ec-ac70-02615a191a47",
 CellID->1342670546],
Cell[8214, 193, 238, 4, 25, "Text",ExpressionUUID->"b5fbfc73-30ce-46c5-bc09-645507f7b925",
 CellID->105986853],
Cell[CellGroupData[{
Cell[8477, 201, 615, 14, 23, "Input",ExpressionUUID->"0306ac2b-26fb-4219-9024-c906da3f9766",
 CellOpen->False,
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->750821714],
Cell[9095, 217, 2491, 51, 19, "Input",ExpressionUUID->"efcd395e-f41a-45e1-b7ef-015925b37cf1",
 CellOpen->False,
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[11589, 270, 550, 14, 19, "Input",ExpressionUUID->"5f5b6158-8185-4aa5-8cc6-778373216699",
 CellOpen->False,
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}]
}, Closed]],
Cell[12154, 287, 2207, 43, 159, "Print",ExpressionUUID->"891f35d2-aef9-488d-b91d-df4d7bf21bdb",
 CellID->159376748],
Cell[14364, 332, 3807, 118, 213, "TechNote",ExpressionUUID->"cfcd32e8-7db5-4cf0-a675-b9f059462be9"],
Cell[18174, 452, 1890, 53, 105, "Text",ExpressionUUID->"7f68012b-cc7b-45ff-892e-2a03be8c006f",
 CellID->1588483917]
}, Open  ]]
}, Open  ]]
}
]
*)

